/**
 * MachForm
 * 
 * © 2007-2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

//function to display error message on the payment form
const mf_handle_errors = (error) => {
	//enable submit button again
	$("#btn_submit_payment").prop("disabled",false);
	$("#btn_submit_payment").val($("#btn_submit_payment").data('originallabel'));
	$("#mf_payment_loader_img").hide();

	if(error.message != undefined){
		$("#error_message_title").text("We couldn't process your payment.");
		$("#error_message_desc").html("<strong>" + error.message + "</strong>");

		$("#error_message").show();
		alert("We couldn't process your payment. Please review the error details and try again.");
	}else{
		//display the generic error message
		$("#error_message").show();
		alert("We couldn't process your payment. Please review the highlighted fields and try again.");
	}

	mf_adjust_iframe_height();
}

//function to automatically adjust the iframe height based on the content
const mf_adjust_iframe_height = () => {
	if($("html").hasClass("embed")){
		$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
		
		//do it once more after 0.5 second, to ensure all resources are loaded
		setTimeout(() => {
			$.postMessage({mf_iframe_height: $('body').outerHeight(true)}, '*', parent );
		}, 500);
	}
}

//the main event handler
document.addEventListener('DOMContentLoaded', async () => {
	//initialize Stripe.js
	const form_id 	= $("#form_id").val();
	const record_id = $("#main_body").data("recordid");
	const is_recurring_payment = $("#main_body").data("recurring");

	const stripe = Stripe(mf_stripe_options.public_key);

	//if recurring payment, set payment_mode to 'subscription', otherwise 'payment'
	const payment_mode = (is_recurring_payment == '1') ? 'subscription' : 'payment';
	
	const element_options = {
		mode: payment_mode,
		amount: mf_stripe_options.amount,
		currency: mf_stripe_options.currency,
		setup_future_usage: 'off_session',
		
		appearance: { 
			theme : 'stripe', 
			rules: {
				'.Input': {
				padding: '6px 12px',
				}
			}
		} 
	};

	const elements = stripe.elements(element_options);

	const payment_element_options = { layout: 'tabs'}; //layout: 'tabs','accordion'
	const payment_element = elements.create('payment', payment_element_options);

	payment_element.mount('#stripe-payment-element');

	//when payment element is ready, make sure to set the height of the iframe
	payment_element.on('ready', () => {
		mf_adjust_iframe_height();
	});

	payment_element.on('change', () => {
		mf_adjust_iframe_height();
	});

	//create the billing and shipping address element as needed
	if($("#stripe-billing-address-element").length > 0){
		const billing_address_element = elements.create('address', 
												{ 
													mode: 'billing',
													autocomplete: { mode: 'disabled' } 
												});
		billing_address_element.mount('#stripe-billing-address-element');

		//when billing address element is ready, make sure to set the height of the iframe
		billing_address_element.on('ready', () => {
			mf_adjust_iframe_height();
		});

		billing_address_element.on('change', () => {
			mf_adjust_iframe_height();
		});
	}

	if($("#stripe-shipping-address-element").length > 0){
		const shipping_address_element = elements.create('address', 
												{ 
													mode: 'shipping',
													autocomplete: { mode: 'disabled' } 
												});
		shipping_address_element.mount('#stripe-shipping-address-element');

		//when shipping address element is ready, make sure to set the height of the iframe
		shipping_address_element.on('ready', () => {
			mf_adjust_iframe_height();
		});

		shipping_address_element.on('change', () => {
			mf_adjust_iframe_height();
		});
	}
	

	//handle form submissions
	const payment_form = document.querySelector('#form_' + form_id);
	payment_form.addEventListener('submit', async (e) => {
		
		//avoid a full page POST request.
		e.preventDefault();

		//disable submit button and display processing text
		$("#btn_submit_payment").val("Processing. Please wait...");
		$("#btn_submit_payment").prop("disabled",true);
		$("#mf_payment_loader_img").show();

		//trigger form validation and wallet collection
		const {error: elements_submit_error} = await elements.submit();
		if (elements_submit_error) {
			mf_handle_errors({}); 
			return;
		}

		//create the PaymentIntent and obtain clientSecret
		let clientSecret;
		let confirmType;

		try{
			const formData = new FormData();
			formData.append('form_id', form_id);
			formData.append('record_id', record_id);
			formData.append('mfsid', $("#mfsid").val());

			const res = await fetch("payment_stripe_handler.php", {
				method: "POST",
				body: formData
			});

			if (!res.ok) {
				//server responded with an HTTP error (e.g. 500, 404, etc)
				throw new Error(`HTTP error ${res.status} - ${res.statusText}`);
			}			

			const res_json = await res.json();

			if(res_json.status == 'ok'){
				clientSecret = res_json.client_secret;
				confirmType  = res_json.type;
			}else{
				//server responded with an error message
				throw new Error(res_json.message);
			}
		}catch(error){
			mf_handle_errors(error);
			return;
		}

		//confirm the card payment that was created server side
		//and redirect to the return_url upon success
		let final_return_url;
		let mfsid_value = $("#mfsid").val();
		if(typeof mfsid_value === 'undefined' || mfsid_value === null){
			final_return_url = $('base').attr('href') + `payment_stripe_return.php?form_id=${form_id}&record_id=${record_id}`;
		}else{
			final_return_url = $('base').attr('href') + `payment_stripe_return.php?form_id=${form_id}&record_id=${record_id}&mfsid=` + $("#mfsid").val();
		}

		const confirmIntent = confirmType === "setup" ? stripe.confirmSetup : stripe.confirmPayment;
		const {error: confirm_payment_error} = await confirmIntent({
			elements,
			clientSecret,
			confirmParams: {
				return_url: final_return_url
			}
		});

		if(confirm_payment_error) {
			mf_handle_errors(confirm_payment_error);
			return;
		}
	});
});